"use client"
import { useState, useEffect } from "react";

export default function ScrollToTopButton() {

  const [isVisible, setIsVisible] = useState(false);

  const toggleVisibility = () => {
    if (window.pageYOffset > 300) {
      setIsVisible(true);
    } else {
      setIsVisible(false);
    }
  };

  const scrollToTop = () => {
    window.scrollTo({
      top: 0,
      behavior: "smooth",
    });
  };

  useEffect(() => {
    window.addEventListener("scroll", toggleVisibility);
    return () => {
      window.removeEventListener("scroll", toggleVisibility);
    };
  }, []);

  return (
    <button
      className={`fixed bottom-5 right-5  h-10 w-10 text-black bg-orange-200 hover:bg-golden hover:text-white  rounded-full animate-bounce z-10
        ${
          isVisible ? "opacity-100" : "opacity-0"
        } transition-opacity duration-300`}
      onClick={scrollToTop}
    >
      ↑
    </button>
  );
}